import numpy as np

# Comparison matrix
A = np.array([
    [1, 2, 5, 7, 9],
    [1/2, 1, 3, 5, 7],
    [1/5, 1/3, 1, 3, 7],
    [1/7, 1/5, 1/3, 1, 3],
    [1/9, 1/7, 1/7, 1/3, 1]
])

# Compute the eigenvalues and eigenvectors
eigenvalues, eigenvectors = np.linalg.eig(A)

# The eigenvalue with the maximum value
lambda_max = np.max(eigenvalues)

# Corresponding eigenvector
principal_eigenvector = eigenvectors[:, np.argmax(eigenvalues)]

# Normalizing the principal eigenvector
normalized_principal_eigenvector = principal_eigenvector / np.sum(principal_eigenvector)

print("Eigenvalues: ", eigenvalues)
print("Eigenvectors: ", eigenvectors)
print("Lambda Max (Max Eigenvalue): ", lambda_max)
print("Principal Eigenvector: ", principal_eigenvector)
print("Normalized Principal Eigenvector (Priority Vector): ", normalized_principal_eigenvector)

n = A.shape[0]  # number of comparisons
CI = (lambda_max - n) / (n - 1)

print("Consistency Index (CI): ", CI)

# Calculate the Consistency Ratio (CR)
# For n=5, the random index (RI) is approximately 1.12
RI = 1.12
CR = CI / RI

print("Consistency Ratio (CR): ", CR)

# Check if the consistency ratio is acceptable
if CR < 0.1:
    print("The consistency ratio is below 0.1, the judgments are consistent.")
else:
    print("The consistency ratio is above 0.1, the judgments are inconsistent. Please revise the comparisons.")